﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace catalog
{
    public partial class Form1 : Form
    {
        String path, dir, ext, fname;//
        int CFlg;
        int[] Chk;
        float[] Rh;

        String[] flist=new string[5000];

        int Total,Chk_Total;
        int flg,YFlg;
        int ChkFlg;
        int xx, yy,yc=15;
        Pen p;

        public int MFlg;

        public Form1()
        {
            InitializeComponent();
        }
        //********************************* SubRoutine **********************************************************

        private void pos_calc(int inx)
        {
            yy = inx / 10;
            yy = yy * 140 + 110;
            xx = inx % 10;
            xx = xx * 140 + 10;

        }

        private void restart()
        {
            TakeFile();
            Chk_Clear();
            Disp();


        }

        private void Repaint_Clear()
        {
             p = new Pen(Color.White, 5);
             Repaint();

        }

        private void YDrow(int inx,int eflg)
        {
            
            pos_calc(inx);

            try
            {
                Graphics g = pictureBox1.CreateGraphics();

                p = new Pen(Color.White, 5);

                if (eflg == 255)
                {
                    p = new Pen(Color.Yellow, 5);
                }
                g.DrawLine(p, xx, yy+yc, xx + 109, yy+yc);

                g.Dispose();

                Repaint();
            }

            catch
            {
                ;
            }


        }


        private void Repaint()
        {
            int  inx;

            if (Chk_Total == 0)
            {
                if(ChkFlg!=255)
                      return;
            }

            Graphics g = pictureBox1.CreateGraphics();
            for (inx = 0; inx < Total+1; inx++)
            {
                if (Chk[inx] == 255)
                {
                    pos_calc(inx);
                    p = new Pen(Color.Red, 5);

                    g.DrawLine(p, xx, yy+yc, xx + 109, yy+yc);

                   
                }
                if(ChkFlg==255)
                {
                    pos_calc(inx);
                    g.DrawLine(p, xx, yy + yc, xx + 109, yy + yc);

                }

            }
            g.Dispose();
           
        }

        private void Disp()
        {
            int x, y, i,h,w;
            float r0;

            if(Total<0)
            {
                pictureBox1.Image = null;
                return;

            }
            button2.Enabled = true;
            openToolStripMenuItem.Enabled = false;

            pictureBox1.Image = null;
            Bitmap canvas = new Bitmap(pictureBox1.Width, pictureBox1.Height);

            Graphics g = Graphics.FromImage(canvas);
            x = 0;
            y = 0;
            System.Drawing.Image img;

            for (i = 0; i < Total + 1; i++)
            {
                img = Image.FromFile(flist[i]);
               
                if(img.Width> img.Height)
                {
                    r0 = (float)130 / img.Width;
                    w = (int)(img.Width * r0);
                    h = (int)(img.Height * r0);
                }
                else
                {
                    r0 = (float)120 / img.Height;
                    w = (int)(img.Width * r0);
                    h = (int)(img.Height * r0);
                }


                Rh[i] = r0;

                g.DrawImage(img, x, y, w, h);


                img.Dispose();

                pictureBox1.Image = canvas;
                pictureBox1.Refresh();

                if (((i + 1) % 10) == 0)
                {
                    x = 0;
                    y = (i + 1) / 10 * 140;

                }
                else
                {
                    x = x + 140;
                }

               Repaint();
                Application.DoEvents();
                if(CFlg==255)
                {
                    CFlg = 0;
                    break;
                }
            }

            g.Dispose();

            openToolStripMenuItem.Enabled = true;
            button2.Enabled = false;

        }
        private void TakeFile()
        {
            string s;
            int i = 0;
            // jpg"ファイルをすべて取得する
            //AllDirectories　　サブフオルダ－も含め全て列挙
            //TopDirectoryOnly　そのフオルダ－のみ列挙

            //   System.IO.DirectoryInfo di = new System.IO.DirectoryInfo(dir);

            //   System.IO.FileInfo[] files = di.GetFiles("*" + ext, System.IO.SearchOption.TopDirectoryOnly);

            string[] files = Directory.GetFiles(dir, "*.*", System.IO.SearchOption.TopDirectoryOnly);
 
            for (i=0;i<5000;i++)
            {
                flist[i] = "";
            }

            i = -1;
            foreach (string f in files)
            {
                s=f.ToLower();

                if ((s.Contains(".jpg")) || (s.Contains(".bmp")) || (s.Contains(".png")))
                {
                    flist[++i] = f;
                }

            }

            Total = i;

            pictureBox1.Height = ((Total / 10) + 1) * 140;

            Rh=new float[Total + 1];
            Chk = new int[Total + 1];
            Chk_Total = 0;
            label4.Text = (Total+1).ToString();
            if(Total>0)
            {
                checkToolStripMenuItem1.Enabled = true;

            }

         }
      private void Chk_Clear()
        {
            int i;
            for(i=0;i<Total+1;i++)
            {
                Chk[i] = 0;

            }

            Repaint_Clear();
            Chk_Total = 0;
            label3.Text = Chk_Total.ToString();
        }
        //---------------------------------------------------------------------------------------------
 
        private void Form1_Load(object sender, EventArgs e)
        {
            Width = 140 * 10 + 50;
            Height = 140 * 6+50;

            panel1.Width = 140 * 10+30;
            panel1.Height = Height - 70;
            pictureBox1.Width = 140 * 10;
            pictureBox1.Left =10;
            pictureBox1.Top = 0;
            YFlg = -1;
            Total = -1;

        }

 

        private void pictureBox1_MouseClick(object sender, MouseEventArgs e)
        {
            int x = e.X;
            int y = e.Y;
            int n = y / 140;
            int a = x / 140;
            int inx = n * 10 + a ;



            if((inx>(Total))||(inx<0)||(Total==-1))
            {
                return;
            }

            if (e.Button == MouseButtons.Right)
            {
                pos_calc(inx);

                Graphics g = pictureBox1.CreateGraphics();
 
               

                if (Chk[inx]==0)
                {
                    Pen p = new Pen(Color.Red, 5);
                    g.DrawLine(p, xx, yy+yc, xx + 109, yy+yc);
                    Chk[inx] = 255;
                    Chk_Total++;
                    コマンドToolStripMenuItem.Enabled = true;
                    label3.Text = Chk_Total.ToString();

                }
                else
                {
                    Pen p = new Pen(Color.White, 5);
                    g.DrawLine(p, xx, yy+yc, xx + 109, yy+yc);
                    Chk[inx] = 0;
                    Chk_Total--;
                    label3.Text = Chk_Total.ToString();

                    if (Chk_Total==0)
                    {
                        コマンドToolStripMenuItem.Enabled = false;
                    }
                }

                g.Dispose();

            }
            else
            {
                if(YFlg==-1)
                {
                    YDrow(inx, 255);


                }
                else
                {

                    YDrow(YFlg, 0);
                    YDrow(inx, 255);                    
                }

                YFlg = inx;
                String s = Application.ExecutablePath;
                String d = System.IO.Path.GetDirectoryName(s);

                s = d + "\\Img.exe";
                Clipboard.Clear();

                int py =(int)((float) (y - n * 140) / Rh[inx]);
                int px = (int)((float)(x - a * 140) / Rh[inx]);

                string wy = py.ToString();
                string wx = px.ToString();

                


                d = flist[inx] + ","+wx+","+wy;
                Clipboard.SetDataObject(d);

                // Clipboard.SetDataObject(flist[I]);
                System.Diagnostics.Process.Start(s);


            }

        }

        private void pictureBox1_MouseMove(object sender, MouseEventArgs e)
        {
            int x = e.X;
            int y = e.Y;
            int n = y / 140;
            int a = x / 140;
            int inx = n * 10 + (a);

            if ((inx >( Total)) || (inx < 0))
            {
                return;
            }

            label1.Text = flist[inx];

        }

 
        private void copyToolStripMenuItem_Click(object sender, EventArgs e) //Copy
        {
            string wdir, wpath; ;
            int i;

            Form2 f2 = new Form2();
            f2.MFlg = 0;
            f2.ShowDialog(this);

            wdir = f2.Dir;
            int cancel = f2.CanFlg;

            f2.Dispose();

            if (cancel == 0)
            {
                return;
            }
            p = new Pen(Color.White, 5);
            pictureBox1.Image = null;
            for (i = 0; i < Total + 1; i++)
            {
                if (Chk[i] == 255)
                {
                    fname = System.IO.Path.GetFileName(flist[i]);
                
                    wpath = wdir + "\\" + fname;
                    if (!System.IO.File.Exists(wpath))
                    {
                        try
                        {
                            System.IO.File.Copy(flist[i], wpath);
                        }
                       catch
                        {
                            MessageBox.Show("コピ－出来なかったフアイルがあります", "注意", MessageBoxButtons.OK); ;
                        }
                    }


                }
            }

            MessageBox.Show("コピ－が終わりました", "報告", MessageBoxButtons.OK);
            Chk_Clear();
            
            Disp();

        }

        private void moveToolStripMenuItem_Click(object sender, EventArgs e)  //Move
        {
            string wdir, wpath;
           
            int movflg;
            int i;

            Form2 f2 = new Form2();
            f2.MFlg = 1;
            f2.ShowDialog(this);
            wdir = f2.Dir;
            int cancel = f2.CanFlg;

            f2.Dispose();

            if(cancel==0)
            {
                return;
            }

            p = new Pen(Color.White, 5);

            pictureBox1.Image = null;
            movflg = 0;

            for (i = 0; i < Total + 1; i++)
            {
                if (Chk[i] == 255)
                {
                    fname = System.IO.Path.GetFileName(flist[i]);
                
                    wpath = wdir + "\\" + fname;



                    if (!System.IO.File.Exists(wpath))
                    {

                        try
                        {
                            System.IO.File.Move(flist[i], wpath);
                        }
                        catch
                        {
                            movflg = 255; //error

                        }
                    }
                    else
                    {
                        MessageBox.Show("同名フアイルは移動しません", "報告", MessageBoxButtons.OK);
                    }
                }

            }

            if (movflg != 0)
            {
                MessageBox.Show("移動出来なかったフアイルがあります", "報告", MessageBoxButtons.OK);
            }
            else
            {
                MessageBox.Show("移動が終わりました", "報告", MessageBoxButtons.OK);
            }

            restart();


        }

        private void renameToolStripMenuItem_Click(object sender, EventArgs e)  //Rename
        {
            string w,wn;
 
            int i, n, len, len1;
            //int r;

            Form2 f2 = new Form2();
            f2.MFlg = 2;
            f2.ShowDialog(this);
            fname = f2.NewName;
            w = f2.sNum;
            int cancel=f2.CanFlg;

            f2.Dispose();

            if (cancel==0)
            {
                return;

            }
            p = new Pen(Color.White, 5);
            pictureBox1.Image = null;
            len = w.Length;

            for (i = 0; i < Total + 1; i++)
            {
                if (Chk[i] == 255)
                {
                    path = flist[i];
                    ext = System.IO.Path.GetExtension(path);

                    wn = "00000" + w;
                    len1 = wn.Length;

                    wn = wn.Substring(len1 - len, len);

                    path = System.IO.Path.GetDirectoryName(path) +"\\"+ fname + wn;

                    n = Int32.Parse(w);
                    n++;
                    w = n.ToString();

                    path = path + ext;

                    try
                    {
                        System.IO.File.Move(flist[i], path);
                    }
                    catch
                    {
                        flg = 255;

                    }

                }
            }

         
           if(flg==0)
            {
                MessageBox.Show("Renameが終わりました", "報告", MessageBoxButtons.OK);
            }
            else
            {
                if (File.Exists(path))
                {
                    MessageBox.Show("同名のフアイルがあり、リネ－ム出来ません", "報告", MessageBoxButtons.OK);
                }
                else
                {
                    MessageBox.Show("エラ－がありました", "報告", MessageBoxButtons.OK);
                }
            }

            restart();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Repaint();
        }

 

        private void allCheckToolStripMenuItem1_Click(object sender, EventArgs e)  //All Check
        {
            int i;

            for (i = 0; i < Total + 1; i++)
            {
                Chk[i] = 255;
            }
            Chk_Total = Total+1;
            コマンドToolStripMenuItem.Enabled = true;
            p = new Pen(Color.Red, 5);
            Repaint();
            label3.Text = Chk_Total.ToString();
        }

        private void dIR作成ToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            Form3 f3 = new Form3();

            f3.ShowDialog(this);

            f3.Dispose();

        }


        private void button2_Click(object sender, EventArgs e)
        {
            CFlg = 255;
        }

        private void exitToolStripMenuItem1_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void openToolStripMenuItem_Click(object sender, EventArgs e)
        {
            openFileDialog1.FileName = "";
            openFileDialog1.ShowDialog();
            path = openFileDialog1.FileName;

            if (path == "") return;

            pictureBox1.Image = null;

           // fname = System.IO.Path.GetFileName(path);
            dir = System.IO.Path.GetDirectoryName(path);
            ext = System.IO.Path.GetExtension(path);
            ext = ext.ToLower();
            TakeFile();

            Disp();
        }

        private void allClearToolStripMenuItem1_Click(object sender, EventArgs e)  //All Clean
        {
            int i;
            
            if(Chk_Total==0)
            {
                return;
            }

            for (i = 0; i < Total + 1; i++)
            {
                Chk[i] = 0;
            }
            Chk_Total = 0;

            p = new Pen(Color.White, 5);
            ChkFlg = 255;
            //Repaint_Clear();
            Repaint();
            ChkFlg = 0;
            コマンドToolStripMenuItem.Enabled = false;
            label3.Text = Chk_Total.ToString();
        }

        private void delToolStripMenuItem1_Click(object sender, EventArgs e)  //Del
        {
            int i;
            for(i=0;i<Total+1;i++)
            {
              if(Chk[i]==255)
                {
                    try
                    {
                        System.IO.File.Delete(flist[i]);

                    }
                    catch
                    {
                        MessageBox.Show(flist[i]+"を削除できませんでした", "注意", MessageBoxButtons.OK); 
                    }

                }


            }
            restart();
        }

        private void pictureBox1_Paint(object sender, PaintEventArgs e)
        {
          Repaint();

        }



        //************************************************************************************************

 
    }
}
